#include "lcd.h"

LCD_CONFIGURATION LcdConfig;
extern volatile bool interrupt_pending;
extern char settings[32];
char display_data[512];
char lcd_data[16];
uint8_t text_lenght = 0;
uint8_t delay = 0;
const  unsigned char betwk[] = {0x02,0x04,0x0E,0x01,0x0F,0x11,0x0F,0x00,    //
                                0x02,0x04,0x0E,0x11,0x1F,0x10,0x0E,0x00,    //
                                0x02,0x04,0x0C,0x04,0x04,0x04,0x0E,0x00,    //
                                0x02,0x04,0x0E,0x11,0x11,0x11,0x0E,0x00,    //
                                0x02,0x04,0x11,0x11,0x11,0x13,0x0D,0x00,    //
                                0x0A,0x00,0x11,0x11,0x11,0x13,0x0D,0x00,    //
                                0x05,0x0A,0x11,0x11,0x11,0x13,0x0D,0x00,    //
                                0x05,0x0A,0x0E,0x11,0x11,0x11,0x0E,0x00};   //

void WriteSPI(unsigned char data)
{
    PIR1bits.SSP1IF = 0;
    SSP1BUF = data;
    while(!PIR1bits.SSP1IF);
}

void LcdInit(void)
{
    __delay_ms(20);
    LcdContrast(20); 
    LcdCmd(0x38);
    LcdCmd(0x40);
    for(unsigned char i = 0; i < 64; i++)
    {
        LcdData(betwk[i]);
    }
    LcdCmd(0x01);
    LcdCmd(0x02);
    LcdCmd(0x0C);
    LcdCmd(0x80);
    LcdBacklight(LcdConfig.BACKLIGHT);
    interrupt_pending = false;
}

void LcdPutc(char c)
{
    switch(c) {
	    case '':  c = 0x00; break;
	    case '':  c = 0x01; break;
	    case '':  c = 0x02; break;
	    case '':  c = 0x03; break;
	    case '':  c = 0x04; break;
	    case '':  c = 0x05; break;
	    case '':  c = 0x06; break;
	    case '':  c = 0x07; break;
	    case '':  c = 0xEF; break;
    } 
    LcdData(c);
}

void LcdPuts(const char *str)
{
    while(*str)
    {
        LcdPutc(*str++);
    }
}

void LcdPuts_16(const char *str)
{
    for(unsigned char i = 0; i < 16; i++)
    {
        if(*str == 0)
        {
            LcdPutc(' ');
        }
        else
        {
            LcdPutc(*str);
        }
        str++;
    }
}

void LcdMain(void)
{
    uint8_t i = 0;
    uint16_t j = 0;
    while(interrupt_pending == false)
    {
        if(settings[0] == 0xAA)
        {
            for(i = 0; i < 16; i++)
            {
                if(interrupt_pending == true)return;
                
                if(display_data[i+j] != 0xFF && display_data[i+j] != 0x00)
                {
                    lcd_data[i] = 0;
                    lcd_data[i] = display_data[i+j];
                }
                else
                {
                    for(i = 0; i < 16; i++)
                    {
                        LcdCmd(0x80);

                        if(text_lenght == 16)
                        {
                            LcdPuts(lcd_data);
                        }
                        else
                        {
                            LcdPuts_16(lcd_data);
                        }
                        delay_ms((uint16_t)delay * 100);
                        for(j = 0; j < 16; j++)
                        {
                            lcd_data[j] = lcd_data[j+1];
                        }
                        lcd_data[15] = display_data[i];
                    }
                    j = 0;
                    i = 0;
                }
            }
            LcdCmd(0x80);
            if(text_lenght == 16)
            {
                LcdPuts(lcd_data);
            }
            else
            {
                LcdPuts_16(lcd_data);
            }
            delay_ms((uint16_t)delay * 100);
            j++;
        }  
    }
}